/* -*- mode: C++; tab-width: 4 -*- */
/* ===================================================================== *\
	Copyright (c) 2000-2001 Palm, Inc. or its subsidiaries.
	All rights reserved.

	This file is part of the Palm OS Emulator.

	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.
\* ===================================================================== */

#ifndef EmRegsS1D13A03_h
#define EmRegsS1D13A03_h

#include "EmHAL.h"				// EmHALHandler
#include "EmPalmStructs.h"
#include "EmRegs.h"
#include "EmStructs.h"			// RGBList

class SessionFile;
class EmScreenUpdateInfo;


#define s1d13a03RegsAddr			(0x08000000)
#define s1d13a03VideoMemStart	    (0x08040000)
#define s1d13a03VideoMemSize		(112 * 1024L)


class EmRegsS1D13A03 : public EmRegs, public EmHALHandler
{
	public:
								EmRegsS1D13A03				(emuptr baseRegsAddr,
															 emuptr baseVideoAddr);
		virtual					~EmRegsS1D13A03				(void);

			// EmRegs overrides
		virtual void			Initialize					(void);
		virtual void			Reset						(Bool hardwareReset);
		virtual void			Save						(SessionFile&);
		virtual void			Load						(SessionFile&);
		virtual void			Dispose						(void);

		virtual void			SetSubBankHandlers			(void);
		virtual uint8*			GetRealAddress				(emuptr address);
		virtual emuptr			GetAddressStart				(void);
		virtual uint32			GetAddressRange				(void);

			// EmHAL overrides
		virtual Bool			GetLCDScreenOn				(void);
		virtual Bool			GetLCDBacklightOn			(void);
		virtual Bool			GetLCDHasFrame				(void);
		virtual void			GetLCDBeginEnd				(emuptr& begin, emuptr& end) = 0;
		virtual void			GetLCDScanlines				(EmScreenUpdateInfo& info) = 0;

	private:
		uint32					powerSaveConfigurationRead	(emuptr address, int size);

		void 					invalidateWriteX			(emuptr address, int size, uint32 value);
		void 					lutWriteAddressWrite		(emuptr address, int size, uint32 value);
		void 					lutReadAddressWrite		    (emuptr address, int size, uint32 value);

	protected:
		void					PrvGetPalette				(RGBList& thePalette);

	protected:
		emuptr					fBaseRegsAddr;
		emuptr					fBaseVideoAddr;
		EmProxyS1D13A03RegsType	fRegs;
		RGBType					fClutData[256];
};


class EmRegsS1D13A03Morf : public EmRegsS1D13A03
{
	public:
								EmRegsS1D13A03Morf			(emuptr baseRegsAddr,
															     emuptr baseVideoAddr);
		virtual					~EmRegsS1D13A03Morf			(void);

		virtual void			SetSubBankHandlers			(void);

		virtual void			GetLCDBeginEnd				(emuptr& begin, emuptr& end);
		virtual void			GetLCDScanlines				(EmScreenUpdateInfo& info);

	private:
		void 					reservedWrite				(emuptr address, int size, uint32 value);

	private:
		int32					PrvGetLCDDepth				(void);
};

#endif	/* EmRegsS1D13A03_h */
